<?php
session_start();
include 'includes/auth.php';
include 'includes/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['visitor_id'])) {
    $visitor_id = (int)$_POST['visitor_id'];

    $stmt = $conn->prepare("DELETE FROM visitors WHERE id = ?");
    $stmt->bind_param("i", $visitor_id);

    if ($stmt->execute()) {
        $_SESSION['success'] = "Visitor logged out successfully.";
    } else {
        $_SESSION['error'] = "Failed to log out visitor.";
    }

    $stmt->close();
} else {
    $_SESSION['error'] = "Invalid request.";
}

header("Location: attendance.php");
exit;
